<?php
session_start();
if (!isset($_SESSION['login'])) { header("Location: login.php"); exit; }
require 'koneksi.php';

$daftar_kelas = [
    "X TKR 1","X TKR 2","X TKR 3","X TKR 4",
    "X TSM 1","X TSM 2","X TSM 3","X TSM 4",
    "X TPTUP 1","X TPTUP 2","X TPTUP 3",
    "X TEI 1","X TEI 2","X TEI 3",
    "X TBKR 1","X TBKR 2",
    "XI TKR 1","XI TKR 2","XI TKR 3","XI TKR 4",
    "XI TSM 1","XI TSM 2","XI TSM 3","XI TSM 4",
    "XI TPTUP 1","XI TPTUP 2","XI TPTUP 3",
    "XI TEI 1","XI TEI 2","XI TEI 3",
    "XI TBKR 1","XI TBKR 2",
    "XII TKR 1","XII TKR 2","XII TKR 3","XII TKR 4",
    "XII TSM 1","XII TSM 2","XII TSM 3","XII TSM 4","XII TSM 5",
    "XII TPTUP 1","XII TPTUP 2","XII TPTUP 3",
    "XII TEI 1","XII TEI 2",
    "XII TBKR 1","XII TBKR 2"
];

$tgl = $_GET['tgl'] ?? date("Y-m-d");

// Ambil data kehadiran
$data = mysqli_query($koneksi, "SELECT * FROM kehadiran WHERE tanggal='$tgl'");
$hadir = [];
while ($row = mysqli_fetch_assoc($data)) {
    $hadir[$row['kelas']] = $row;
}

// Nama hari
$hariIndo = [
    'Sunday'    => 'Minggu',
    'Monday'    => 'Senin',
    'Tuesday'   => 'Selasa',
    'Wednesday' => 'Rabu',
    'Thursday'  => 'Kamis',
    'Friday'    => 'Jumat',
    'Saturday'  => 'Sabtu'
];
$hari = $hariIndo[date('l', strtotime($tgl))];

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=Rekap-MBG-$tgl.xls");
header("Pragma: no-cache");
header("Expires: 0");

echo "<table border='1'>
    <tr><th colspan='7'><strong>Rekap Kehadiran MBG - $tgl ($hari)</strong></th></tr>
    <tr>
      <th>No</th>
      <th>Tanggal</th>
      <th>Hari</th>
      <th>Kelas</th>
      <th>Koordinator</th>
      <th>Jumlah Hadir</th>
      <th>Status</th>
    </tr>";

$no = 1;
$total = 0;
foreach ($daftar_kelas as $kelas) {
    if (isset($hadir[$kelas])) {
        $row = $hadir[$kelas];
        $koordinator = $row['koordinator'];
        $jumlah = $row['jumlah_hadir'];
        $status = "Sudah Input";
        $total += (int)$jumlah;
    } else {
        $koordinator = "-";
        $jumlah = "-";
        $status = "Belum Input";
    }
    echo "<tr>
        <td>{$no}</td>
        <td>{$tgl}</td>
        <td>{$hari}</td>
        <td>{$kelas}</td>
        <td>{$koordinator}</td>
        <td>{$jumlah}</td>
        <td>{$status}</td>
    </tr>";
    $no++;
}

echo "<tr>
  <td colspan='5'><strong>TOTAL</strong></td>
  <td><strong>{$total}</strong></td>
  <td></td>
</tr>";
echo "</table>";
?>
