<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

require 'koneksi.php';

// --- Statistik ---
$totalKunjungan = $conn->query("SELECT COUNT(*) FROM tb_kunjungan")->fetch_row()[0] ?? 0;
$kunjunganHariIni = $conn->query("SELECT COUNT(*) FROM tb_kunjungan WHERE DATE(waktu)=CURDATE()")->fetch_row()[0] ?? 0;
$totalMember = $conn->query("SELECT COUNT(*) FROM tb_member")->fetch_row()[0] ?? 0;

// --- Filter tanggal grafik ---
$tgl_grafik_mulai = $_GET['tgl_grafik_mulai'] ?? date('Y-m-01');
$tgl_grafik_selesai = $_GET['tgl_grafik_selesai'] ?? date('Y-m-d');

// --- Grafik ---
$labels = [];
$data = [];
$stmt = $conn->prepare("
    SELECT DATE(waktu) as tgl, COUNT(*) as jml
    FROM tb_kunjungan
    WHERE DATE(waktu) BETWEEN ? AND ?
    GROUP BY DATE(waktu)
    ORDER BY tgl ASC
");
$stmt->bind_param("ss", $tgl_grafik_mulai, $tgl_grafik_selesai);
$stmt->execute();
$stmt->bind_result($tgl, $jml);
while ($stmt->fetch()) {
    $labels[] = $tgl;
    $data[]   = $jml;
}
$stmt->close();

// --- Filter tanggal history ---
$tgl_mulai = $_GET['tgl_mulai'] ?? date('Y-m-01');
$tgl_selesai = $_GET['tgl_selesai'] ?? date('Y-m-d');

// --- History Kunjungan ---
$stmt2 = $conn->prepare("
    SELECT id, nama, kategori, tujuan, asal_instansi,
           DATE(waktu) as tanggal, TIME(waktu) as jam
    FROM tb_kunjungan
    WHERE DATE(waktu) BETWEEN ? AND ?
    ORDER BY waktu DESC
");
$stmt2->bind_param("ss", $tgl_mulai, $tgl_selesai);
$stmt2->execute();
$stmt2->bind_result($id, $nama, $kategori, $tujuan, $asal_instansi, $tanggal, $jam);

$hasil = [];
while ($stmt2->fetch()) {
    $hasil[] = [
        'id' => $id,
        'nama' => $nama,
        'kategori' => $kategori,
        'tujuan' => $tujuan,
        'asal_instansi' => $asal_instansi,
        'tanggal' => $tanggal,
        'jam' => $jam
    ];
}
$stmt2->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Admin Buku Tamu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; }
    .card { border-radius: 1rem; box-shadow: 0 3px 10px rgba(0,0,0,0.05); }
    .btn-custom { background:#4a90e2; color:#fff; }
    .btn-custom:hover { background:#357ab7; }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand" href="admin.php"><i class="bi bi-speedometer2"></i> Admin</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link" href="member.php"><i class="bi bi-people"></i> Member</a></li>
        <li class="nav-item"><a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-4">
  <!-- Statistik -->
  <div class="row g-3 mb-4">
    <div class="col-md-4">
      <div class="card text-center p-3">
        <i class="bi bi-people-fill fs-1 text-primary"></i>
        <h6>Total Kunjungan</h6>
        <h3><?= $totalKunjungan ?></h3>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card text-center p-3">
        <i class="bi bi-calendar-check fs-1 text-success"></i>
        <h6>Hari Ini</h6>
        <h3><?= $kunjunganHariIni ?></h3>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card text-center p-3">
        <i class="bi bi-person-badge-fill fs-1 text-warning"></i>
        <h6>Total Member</h6>
        <h3><?= $totalMember ?></h3>
      </div>
    </div>
  </div>

  <!-- Grafik -->
  <div class="card mb-4">
    <div class="card-body">
      <h5><i class="bi bi-graph-up"></i> Grafik Kunjungan</h5>
      <form method="get" class="row g-2 mb-3">
        <div class="col-md-3">
          <input type="date" name="tgl_grafik_mulai" value="<?= $tgl_grafik_mulai ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <input type="date" name="tgl_grafik_selesai" value="<?= $tgl_grafik_selesai ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <button class="btn btn-primary"><i class="bi bi-search"></i> Tampilkan</button>
        </div>
      </form>
      <canvas id="grafikKunjungan" height="100"></canvas>
    </div>
  </div>

  <!-- History Kunjungan -->
  <div class="card mb-4">
    <div class="card-body">
      <h5><i class="bi bi-journal-text"></i> History Kunjungan</h5>
      <form method="get" class="row g-2 mb-3">
        <div class="col-md-3">
          <input type="date" name="tgl_mulai" value="<?= $tgl_mulai ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <input type="date" name="tgl_selesai" value="<?= $tgl_selesai ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <button class="btn btn-primary"><i class="bi bi-search"></i> Tampilkan</button>
          <a href="export_kunjungan.php?tgl_mulai=<?= $tgl_mulai ?>&tgl_selesai=<?= $tgl_selesai ?>" class="btn btn-success">
            <i class="bi bi-file-earmark-excel"></i> Export
          </a>
        </div>
      </form>
      <div class="table-responsive">
        <table class="table table-bordered table-hover">
          <thead class="table-light">
            <tr>
              <th>#</th>
              <th>Nama</th>
              <th>Kategori</th>
              <th>Tujuan</th>
              <th>Instansi</th>
              <th>Tanggal</th>
              <th>Jam</th>
            </tr>
          </thead>
          <tbody>
            <?php if(count($hasil)>0): ?>
              <?php $no=1; foreach($hasil as $row): ?>
              <tr>
                <td><?= $no++ ?></td>
                <td><?= htmlspecialchars($row['nama']) ?></td>
                <td><?= htmlspecialchars($row['kategori']) ?></td>
                <td><?= htmlspecialchars($row['tujuan']) ?></td>
                <td><?= htmlspecialchars($row['asal_instansi']) ?></td>
                <td><?= $row['tanggal'] ?></td>
                <td><?= $row['jam'] ?></td>
              </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="7" class="text-center">Tidak ada data kunjungan</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
const ctx = document.getElementById('grafikKunjungan');
new Chart(ctx, {
  type: 'line',
  data: {
    labels: <?= json_encode($labels) ?>,
    datasets: [{
      label: 'Jumlah Kunjungan',
      data: <?= json_encode($data) ?>,
      borderColor: '#4a90e2',
      backgroundColor: 'rgba(74,144,226,0.3)',
      fill: true,
      tension: 0.3
    }]
  }
});
</script>
</body>
</html>
