<?php
require 'koneksi.php';

$term = isset($_GET['term']) ? trim($_GET['term']) : '';
$data = [];

if ($term !== '') {
    $like = "%{$term}%";
    $sql = "SELECT id, member_id, nama FROM tb_member 
            WHERE nama LIKE ? OR member_id LIKE ? 
            ORDER BY nama ASC LIMIT 10";

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("ss", $like, $like);
        $stmt->execute();
        
        // ganti get_result() → bind_result()
        $stmt->bind_result($id, $member_id, $nama);

        while ($stmt->fetch()) {
            $data[] = [
                "label" => $member_id . " - " . $nama,
                "value" => $id
            ];
        }
        $stmt->close();
    } else {
        error_log("SQL ERROR: " . $conn->error);
    }
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($data);
