<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}
require 'koneksi.php';

$id = $_GET['id'] ?? 0;

// ambil data member
$stmt = $conn->prepare("SELECT member_id, nama, kelas_jurusan FROM tb_member WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($member_id, $nama, $kelas_jurusan);
$stmt->fetch();
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $member_id = $_POST['member_id'];
    $nama = $_POST['nama'];
    $kelas_jurusan = $_POST['kelas_jurusan'];

    $stmt = $conn->prepare("UPDATE tb_member SET member_id=?, nama=?, kelas_jurusan=? WHERE id=?");
    $stmt->bind_param("sssi", $member_id, $nama, $kelas_jurusan, $id);
    $stmt->execute();
    header("Location: member.php?msg=updated");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Edit Member</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
  <h4>Edit Member</h4>
  <form method="post">
    <div class="mb-3">
      <label class="form-label">Member ID</label>
      <input type="text" name="member_id" class="form-control" value="<?= htmlspecialchars($member_id) ?>" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Nama</label>
      <input type="text" name="nama" class="form-control" value="<?= htmlspecialchars($nama) ?>" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Kelas/Jurusan</label>
      <input type="text" name="kelas_jurusan" class="form-control" value="<?= htmlspecialchars($kelas_jurusan) ?>" required>
    </div>
    <button class="btn btn-primary">Update</button>
    <a href="member.php" class="btn btn-secondary">Kembali</a>
  </form>
</div>
</body>
</html>
