<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

require 'koneksi.php';

$tgl_mulai   = $_GET['tgl_mulai'] ?? date('Y-m-01');
$tgl_selesai = $_GET['tgl_selesai'] ?? date('Y-m-d');

// ambil total kunjungan
$stmtCount = $conn->prepare("SELECT COUNT(*) FROM tb_kunjungan WHERE DATE(waktu) BETWEEN ? AND ?");
$stmtCount->bind_param("ss", $tgl_mulai, $tgl_selesai);
$stmtCount->execute();
$stmtCount->bind_result($total);
$stmtCount->fetch();
$stmtCount->close();

// ambil data detail
$stmt = $conn->prepare("SELECT nama, kategori, tujuan, asal_instansi, waktu
                        FROM tb_kunjungan 
                        WHERE DATE(waktu) BETWEEN ? AND ?
                        ORDER BY waktu ASC");
$stmt->bind_param("ss", $tgl_mulai, $tgl_selesai);
$stmt->execute();
$stmt->bind_result($nama, $kategori, $tujuan, $asal_instansi, $waktu);

// set header untuk Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=kunjungan_{$tgl_mulai}_{$tgl_selesai}.xls");

// mulai output HTML
echo "<html><head>
<meta charset='UTF-8'>
<style>
    table { border-collapse: collapse; }
    th, td { border: 1px solid #000; padding: 4px; text-align: left; white-space: nowrap; }
    th { background-color: #f2f2f2; }
    h2, h4 { margin: 0; }
</style>
</head><body>";

echo "<h2>LAPORAN DATA KUNJUNGAN PERPUSTAKAAN</h2>";
echo "<h4>Periode: {$tgl_mulai} s/d {$tgl_selesai}</h4>";
echo "<h4>Total Kunjungan: {$total}</h4><br>";

echo "<table>";
echo "<tr>
        <th>No</th>
        <th>Nama</th>
        <th>Kategori</th>
        <th>Tujuan</th>
        <th>Asal Instansi</th>
        <th>Waktu</th>
      </tr>";

$no = 1;
while ($stmt->fetch()) {
    $asal_instansi = $asal_instansi ?: '-';
    echo "<tr>
            <td>{$no}</td>
            <td>{$nama}</td>
            <td>{$kategori}</td>
            <td>{$tujuan}</td>
            <td>{$asal_instansi}</td>
            <td>{$waktu}</td>
          </tr>";
    $no++;
}
echo "</table>";

echo "</body></html>";

$stmt->close();
exit;
?>
