<?php
session_start();
require 'koneksi.php';

if (isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = md5($_POST['password']);

    $sql = "SELECT username FROM tb_user WHERE username=? AND password=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $username, $password);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $_SESSION['login'] = true;
        $_SESSION['username'] = $username;
        header("Location: admin.php");
        exit;
    } else {
        $error = "Username / Password salah!";
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Login Admin Vokatek 8</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      min-height: 100vh;
      background: url('https://images.unsplash.com/photo-1512820790803-83ca734da794?auto=format&fit=crop&w=1600&q=80') no-repeat center center fixed;
      background-size: cover;
    }
    .login-card {
      backdrop-filter: blur(10px);
      background: rgba(255, 255, 255, 0.9);
      border-radius: 1rem;
    }
    .form-control:focus {
      border-color: #0d6efd;
      box-shadow: 0 0 0 0.2rem rgba(13,110,253,.25);
    }
  </style>
</head>
<body class="d-flex align-items-center">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-5 col-lg-4">
        <div class="card shadow-lg border-0 login-card">
          <div class="card-body p-4">
            <div class="text-center mb-4">
              <i class="bi bi-book-half text-primary" style="font-size:3rem;"></i>
              <h4 class="mt-2">Login Admin <br> Vokatek 8</h4>
            </div>
            <?php if (isset($error)) : ?>
              <div class="alert alert-danger"><i class="bi bi-exclamation-triangle-fill"></i> <?= $error ?></div>
            <?php endif; ?>
            <form method="post">
              <div class="mb-3">
                <label class="form-label"><i class="bi bi-person-circle"></i> Username</label>
                <input type="text" name="username" class="form-control" placeholder="Masukkan username" required autofocus>
              </div>
              <div class="mb-3">
                <label class="form-label"><i class="bi bi-lock-fill"></i> Password</label>
                <input type="password" name="password" class="form-control" placeholder="Masukkan password" required>
              </div>
              <button type="submit" name="login" class="btn btn-primary w-100">
                <i class="bi bi-box-arrow-in-right"></i> Login
              </button>
            </form>
          </div>
        </div>
        <p class="text-center text-light mt-3 small">© <?= date("Y") ?> ICT X Perpustakaan SMKN 8 Bandung</p>
      </div>
    </div>
  </div>
</body>
</html>
