<?php
require 'koneksi.php';

// Ambil input POST
$kategori = $_POST['kategori'] ?? '';
$tujuan   = $_POST['tujuan'] ?? '';

// Inisialisasi variabel
$member_id = null;
$nama = '';
$asal_instansi = null; // hanya untuk non-member

if($kategori === 'member'){
    $member_id = $_POST['member_id'] ?? null;
    if($member_id){
        $stmt = $conn->prepare("SELECT nama FROM tb_member WHERE id=?");
        if(!$stmt){
            die("Prepare failed: " . $conn->error);
        }
        $stmt->bind_param("i", $member_id);
        $stmt->execute();
        $stmt->bind_result($nama_db);
        if($stmt->fetch()){
            $nama = $nama_db;
        }
        $stmt->close();
    }
} else { // non-member
    $nama = trim($_POST['nama_nonmember'] ?? '');
    $asal_instansi = trim($_POST['asal_instansi'] ?? '');
    $member_id = null;
}

// Validasi minimal
if(empty($nama) || empty($tujuan)){
    die("Nama dan tujuan wajib diisi.");
}

// Siapkan query INSERT
$stmt = $conn->prepare("
    INSERT INTO tb_kunjungan 
    (kategori, member_id, nama, asal_instansi, tujuan, waktu) 
    VALUES (?, ?, ?, ?, ?, NOW())
");

if(!$stmt){
    die("Prepare failed: " . $conn->error);
}

// Bind parameter
// untuk member, asal_instansi dikirim NULL
$stmt->bind_param(
    "sisss",
    $kategori,
    $member_id,
    $nama,
    $asal_instansi,
    $tujuan
);

// Eksekusi dan cek hasil
if($stmt->execute()){
    $stmt->close();
    header("Location: index.php?success=1");
    exit;
} else {
    echo "Error saat menyimpan data: " . $stmt->error;
}
?>
