<?php
session_start();
if (!isset($_SESSION['login'])) { header("Location: login.php"); exit; }
require 'koneksi.php';
require 'hari.php';

$daftar_kelas = ["X TKR 1", "X TKR 2", "X TKR 3", "X TKR 4", "X TSM 1", "X TSM 2", "X TSM 3", "X TSM 4", "X TPTUP 1", "X TPTUP 2", "X TPTUP 3", "X TEI 1", "X TEI 2", "X TEI 3", "X TBKR 1", "X TBKR 2", "XI TKR 1", "XI TKR 2", "XI TKR 3", "XI TKR 4", "XI TSM 1", "XI TSM 2", "XI TSM 3", "XI TSM 4", "XI TPTUP 1", "XI TPTUP 2", "XI TPTUP 3", "XI TEI 1", "XI TEI 2", "XI TEI 3", "XI TBKR 1", "XI TBKR 2", "XII TKR 1", "XII TKR 2", "XII TKR 3", "XII TKR 4", "XII TSM 1", "XII TSM 2", "XII TSM 3", "XII TSM 4", "XII TSM 5", "XII TPTUP 1", "XII TPTUP 2", "XII TPTUP 3", "XII TEI 1", "XII TEI 2", "XII TBKR 1", "XII TBKR 2"];
$tgl = $_GET['tgl'] ?? date("Y-m-d");
$hari = hari_indo($tgl);

// ambil data kehadiran
$hadir = [];
$q = mysqli_query($koneksi, "SELECT * FROM kehadiran WHERE tanggal='$tgl'");
while($row = mysqli_fetch_assoc($q)) { $hadir[$row['kelas']] = $row; }

$total = 0;
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin - Rekap Kehadiran</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @media print {
      body * { visibility: hidden; }
      #printable, #printable * { visibility: visible; }
      #printable { position: absolute; left: 0; top: 0; width: 100%; }
    }
  </style>
</head>
<body class="bg-light">

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="admin.php">MBG</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMenu" aria-controls="navMenu" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navMenu">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="index.php">Input Kehadiran</a></li>
        <li class="nav-item"><a class="nav-link active" href="admin.php">Admin</a></li>
      </ul>
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <span class="navbar-text text-white me-2">👤 <?= htmlspecialchars($_SESSION['username']) ?></span>
          <a class="btn btn-outline-light btn-sm" href="logout.php">Logout</a>
        </li>
      </ul>
    </div>
  </div>
</nav>

<div class="container my-4">
  <div class="row g-3 align-items-end">
    <div class="col-12 col-md-4">
      <label class="form-label">Pilih Tanggal</label>
      <form method="get" class="d-flex gap-2">
        <input type="date" name="tgl" value="<?= htmlspecialchars($tgl) ?>" class="form-control">
        <button class="btn btn-primary">Terapkan</button>
      </form>
    </div>
    <div class="col-12 col-md-8 text-md-end">
      <a href="export_excel.php?tgl=<?= urlencode($tgl) ?>" class="btn btn-success">⬇️ Export Excel</a>
      <button class="btn btn-secondary" onclick="window.print()">🖨️ Cetak</button>
    </div>
  </div>

  <div class="card shadow-sm mt-3" id="printable">
    <div class="card-header">
      <strong>Rekap Kehadiran (<?= $hari ?>, <?= htmlspecialchars($tgl) ?>)</strong>
    </div>
    <div class="card-body">
      <div class="mb-3">
        <strong>Belum Input:</strong>
        <?php
          $belum = [];
          foreach ($daftar_kelas as $k) { if (!isset($hadir[$k])) $belum[] = $k; }
          if (count($belum) === 0) echo "<span class='badge bg-success'>Semua kelas sudah input</span>";
          else { echo "<div class='mt-2 d-flex flex-wrap gap-2'>"; foreach($belum as $b) echo "<span class='badge bg-danger'>$b</span>"; echo "</div>"; }
        ?>
      </div>

      <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
          <thead class="table-dark text-center">
            <tr>
              <th>No</th>
              <th>Kelas</th>
              <th>Koordinator</th>
              <th>Jumlah Hadir</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            <?php $no=1; foreach ($daftar_kelas as $k): ?>
              <?php if (isset($hadir[$k])): $r=$hadir[$k]; $total += (int)$r['jumlah_hadir']; ?>
                <tr>
                  <td class="text-center"><?= $no++; ?></td>
                  <td><?= $k; ?></td>
                  <td><?= htmlspecialchars($r['koordinator']); ?></td>
                  <td class="text-center"><?= (int)$r['jumlah_hadir']; ?></td>
                  <td class="text-center"><span class="badge bg-success">Sudah Input</span></td>
                </tr>
              <?php else: ?>
                <tr>
                  <td class="text-center"><?= $no++; ?></td>
                  <td><?= $k; ?></td>
                  <td>-</td>
                  <td class="text-center">-</td>
                  <td class="text-center"><span class="badge bg-danger">Belum Input</span></td>
                </tr>
              <?php endif; ?>
            <?php endforeach; ?>
          </tbody>
          <tfoot>
            <tr class="fw-bold table-secondary">
              <td colspan="3" class="text-end">TOTAL</td>
              <td class="text-center"><?= $total ?></td>
              <td></td>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
