<?php
require 'koneksi.php';
require 'hari.php';
if (session_status() === PHP_SESSION_NONE) session_start();

$tanggal = date("Y-m-d");
$hari = hari_indo($tanggal);

$msg = "";

// Daftar kelas lengkap
$daftar_kelas = [
    "X TKR 1","X TKR 2","X TKR 3","X TKR 4",
    "X TSM 1","X TSM 2","X TSM 3","X TSM 4",
    "X TPTUP 1","X TPTUP 2","X TPTUP 3",
    "X TEI 1","X TEI 2","X TEI 3",
    "X TBKR 1","X TBKR 2",
    "XI TKR 1","XI TKR 2","XI TKR 3","XI TKR 4",
    "XI TSM 1","XI TSM 2","XI TSM 3","XI TSM 4",
    "XI TPTUP 1","XI TPTUP 2","XI TPTUP 3",
    "XI TEI 1","XI TEI 2","XI TEI 3",
    "XI TBKR 1","XI TBKR 2",
    "XII TKR 1","XII TKR 2","XII TKR 3","XII TKR 4",
    "XII TSM 1","XII TSM 2","XII TSM 3","XII TSM 4","XII TSM 5",
    "XII TPTUP 1","XII TPTUP 2","XII TPTUP 3",
    "XII TEI 1","XII TEI 2",
    "XII TBKR 1","XII TBKR 2"
];

// Ambil data kehadiran hari ini
$hadir = [];
$q = mysqli_query($koneksi, "SELECT * FROM kehadiran WHERE tanggal='$tanggal'");
while($row = mysqli_fetch_assoc($q)) { 
    $hadir[$row['kelas']] = $row; 
}

// Hitung total hadir & kelas yang belum input
$total_hadir = 0;
$kelas_belum = [];
foreach ($daftar_kelas as $k) {
    if(isset($hadir[$k])) $total_hadir += (int)$hadir[$k]['jumlah_hadir'];
    else $kelas_belum[] = $k;
}

// Proses simpan data
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $koordinator = mysqli_real_escape_string($koneksi, $_POST['koordinator']);
    $kelas = mysqli_real_escape_string($koneksi, $_POST['kelas']);
    $jumlah = (int)$_POST['jumlah'];

    $cek = mysqli_query($koneksi, "SELECT id FROM kehadiran WHERE tanggal='$tanggal' AND kelas='$kelas'");
    if ($cek && mysqli_num_rows($cek) > 0) {
        $msg = "<div class='alert alert-warning'>Kelas <b>".htmlspecialchars($kelas)."</b> sudah input hari ini.</div>";
    } else {
        $s = mysqli_query($koneksi, "INSERT INTO kehadiran (tanggal, hari, kelas, koordinator, jumlah_hadir) 
                                     VALUES ('$tanggal', '$hari', '$kelas', '$koordinator', $jumlah)");
        if ($s) {
            $msg = "<div class='alert alert-success'>Data berhasil disimpan untuk kelas <b>".htmlspecialchars($kelas)."</b>.</div>";
            // Refresh data hadir
            $hadir[$kelas] = ['koordinator'=>$koordinator, 'jumlah_hadir'=>$jumlah];
            $total_hadir += $jumlah;
            if(($key = array_search($kelas, $kelas_belum)) !== false) unset($kelas_belum[$key]);
        } else {
            $msg = "<div class='alert alert-danger'>Gagal menyimpan data.</div>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Input Kehadiran MBG</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container my-4">

    <!-- Form Input Kehadiran -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-primary text-white">
            <strong>Form Kehadiran MBG (<?= $hari ?>, <?= $tanggal ?>)</strong>
        </div>
        <div class="card-body">
            <?= $msg ?>
            <form method="post" class="row g-3">
                <div class="col-12">
                    <label class="form-label">Nama Koordinator</label>
                    <input type="text" name="koordinator" class="form-control" required>
                </div>
                <div class="col-12">
                    <label class="form-label">Kelas</label>
                    <select name="kelas" class="form-select" required>
                        <option value="">-- Pilih Kelas --</option>
                        <?php foreach($daftar_kelas as $k): ?>
                            <option><?= $k ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-12">
                    <label class="form-label">Jumlah Hadir</label>
                    <input type="number" name="jumlah" min="1" class="form-control" required>
                </div>
                <div class="col-12 d-grid">
                    <button class="btn btn-success">Simpan</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Rekap Kehadiran di bawah form -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-secondary text-white">
            <strong>Rekap Kehadiran Hari Ini</strong>
        </div>
        <div class="card-body">
            <p><strong>Total Hadir:</strong> <?= $total_hadir ?> siswa</p>
            <p><strong>Kelas Belum Input:</strong> 
                <?php
                    if(count($kelas_belum) === 0) echo "<span class='badge bg-success'>Semua kelas sudah input</span>";
                    else {
                        foreach($kelas_belum as $k) echo "<span class='badge bg-danger me-1 mb-1'>$k</span>";
                    }
                ?>
            </p>
            <div class="mt-3">
                <p>Info lebih detail silahkan login:</p>
                <a href="login.php" class="btn btn-primary">Login</a>
            </div>
        </div>
    </div>

</div>

</body>
</html>
