<?php
if (session_status() === PHP_SESSION_NONE) session_start();

// Fungsi untuk menandai menu aktif
function isActive($page) {
    $current = basename($_SERVER['PHP_SELF']);
    return $current === $page ? 'active' : '';
}
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">MBG</a>
    <!-- Hamburger -->
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMenu" aria-controls="navMenu" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <!-- Menu -->
    <div class="collapse navbar-collapse" id="navMenu">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link <?= isActive('index.php') ?>" href="index.php">Input</a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?= isActive('admin.php') ?>" href="admin.php">Admin</a>
        </li>
      </ul>

      <!-- Username -->
      <span class="navbar-text me-3">👤 <?= isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : '-' ?></span>

      <!-- Logout -->
      <?php if(isset($_SESSION['login'])): ?>
        <a class="btn btn-outline-light btn-sm" href="logout.php">Logout</a>
      <?php endif; ?>
    </div>
  </div>
</nav>

<!-- Jangan lupa panggil ini di file utama (index.php, admin.php, dsb) sebelum </body> -->
<!--
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
-->
