<?php require 'koneksi.php'; ?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Daftar Kunjungan Perpustakaan</title>

  <!-- Bootstrap + jQuery UI CSS + Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body 
      {
      min-height: 100vh;
      background: #f5f7fa url('https://images.unsplash.com/photo-1512820790803-83ca734da794?auto=format&fit=crop&w=1600&q=80') no-repeat center center fixed;
      background-size: cover;
    }
    .card {
      border-radius: 1rem;
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(6px);
      box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }
    .btn-custom {
      background: #4a90e2;
      color: #fff;
      font-weight: 600;
      transition: 0.3s;
    }
    .btn-custom:hover {
      background: #357ab7;
      color: #fff;
    }
  </style>
</head>
<body>
  <?php include 'navbar.php'; ?>

  <div class="container py-4">
    <div class="card mx-auto" style="max-width: 700px;">
      <div class="card-body">
        <h3 class="card-title mb-4 text-center">
          <i class="bi bi-journal-bookmark-fill text-primary"></i> 
          Daftar Kunjungan Perpustakaan
        </h3>

        <?php if(isset($_GET['success'])): ?>
          <div class="alert alert-success"><i class="bi bi-check-circle-fill"></i> Data berhasil disimpan!</div>
        <?php endif; ?>

        <form method="post" action="submit_tamu.php" class="row g-3">
          <!-- Kategori -->
          <div class="col-12 col-md-6">
            <label class="form-label"><i class="bi bi-people-fill"></i> Kategori</label>
            <select id="kategori" name="kategori" class="form-select" required>
              <option value="member">Member</option>
              <option value="non_member">Non Member</option>
            </select>
          </div>

          <!-- Cari Member -->
          <div class="col-12 col-md-6 member-field">
            <label class="form-label"><i class="bi bi-search"></i> Cari Member</label>
            <input type="text" id="cariMember" class="form-control" placeholder="Ketik nama atau ID" autocomplete="off">
            <input type="hidden" name="member_id" id="member_id">
          </div>

          <!-- Non-member fields -->
          <div class="col-12 col-md-6 nonmember-field" style="display:none;">
            <label class="form-label"><i class="bi bi-person-fill"></i> Nama Lengkap</label>
            <input type="text" name="nama_nonmember" class="form-control">
          </div>
          <div class="col-12 col-md-6 nonmember-field" style="display:none;">
            <label class="form-label"><i class="bi bi-building"></i> Asal Instansi</label>
            <input type="text" name="asal_instansi" class="form-control">
          </div>

          <!-- Tujuan -->
          <div class="col-12">
            <label class="form-label"><i class="bi bi-flag-fill"></i> Tujuan</label>
            <select name="tujuan" class="form-select" required>
              <option value="">-- Pilih Tujuan --</option>
              <option>Membaca</option>
              <option>Meminjam Buku</option>
              <option>Mengembalikan Buku</option>
              <option>Mengerjakan Tugas</option>
              <option>Lainnya</option>
            </select>
          </div>

          <div class="col-12">
            <button type="submit" class="btn btn-custom w-100">
              <i class="bi bi-save-fill"></i> Simpan
            </button>
          </div>
        </form>
      </div>
      <p class="text-center text-light mt-3 small">© <?= date("Y") ?> Perpustakaan SMKN 8 Bandung</p>
    </div>
  </div>

  <!-- Scripts -->
  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    $(function(){
      // toggle fields
      $('#kategori').on('change', function(){
        if($(this).val() === 'member'){
          $('.member-field').show(); $('.nonmember-field').hide();
        } else {
          $('.member-field').hide(); $('.nonmember-field').show();
        }
      }).trigger('change');

      // autocomplete
      $('#cariMember').autocomplete({
        source: function(request, response) {
          $.ajax({
            url: 'autocomplete.php',
            dataType: 'json',
            data: { term: request.term },
            success: function(data) { response(data); },
            error: function(xhr){ console.error('autocomplete error', xhr); response([]); }
          });
        },
        minLength: 2,
        select: function(event, ui){
          $('#cariMember').val(ui.item.label);
          $('#member_id').val(ui.item.value);
          return false;
        }
      });
    });
  </script>
</body>
</html>
