<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}
require 'koneksi.php';

// Pagination setup
$perPage = 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $perPage;

// Filter
$search = $_GET['search'] ?? '';
$where = '';
$params = [];
$types = '';

if ($search) {
    $where = "WHERE member_id LIKE ? OR nama LIKE ? OR kelas_jurusan LIKE ?";
    $like = "%" . $search . "%";
    $params = [$like, $like, $like];
    $types = "sss";
}

// Count total
$sqlCount = "SELECT COUNT(*) as total FROM tb_member $where";
$stmt = $conn->prepare($sqlCount);
if ($where) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$stmt->bind_result($totalRows);
$stmt->fetch();
$stmt->close();
$totalRows = $totalRows ?? 0;
$totalPages = ceil($totalRows / $perPage);

// Ambil data
$sql = "SELECT id, member_id, nama, kelas_jurusan 
        FROM tb_member 
        $where 
        ORDER BY id DESC 
        LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);
if ($where) {
    $allParams = array_merge($params, [$perPage, $offset]);
    $stmt->bind_param($types . "ii", ...$allParams);
} else {
    $stmt->bind_param("ii", $perPage, $offset);
}
$stmt->execute();
$stmt->bind_result($id, $member_id, $nama, $kelas_jurusan);

$members = [];
while ($stmt->fetch()) {
    $members[] = [
        'id' => $id,
        'member_id' => $member_id,
        'nama' => $nama,
        'kelas_jurusan' => $kelas_jurusan
    ];
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Kelola Member</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow">
  <div class="container">
    <a class="navbar-brand fw-bold" href="admin.php">📚 Admin Perpustakaan</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link active" href="member.php"><i class="bi bi-people"></i> Member</a></li>
        <li class="nav-item"><a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0"><i class="bi bi-people"></i> Daftar Member</h4>
    <form class="d-flex" method="get">
      <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" class="form-control me-2" placeholder="Cari member...">
      <button class="btn btn-outline-secondary"><i class="bi bi-search"></i></button>
    </form>
  </div>

  <?php if(isset($_GET['msg'])): ?>
    <div class="alert alert-info">
      <?php if($_GET['msg']=='added') echo "✅ Member berhasil ditambahkan!";
            elseif($_GET['msg']=='updated') echo "✏️ Member berhasil diupdate!";
            elseif($_GET['msg']=='deleted') echo "🗑️ Member berhasil dihapus!"; ?>
    </div>
  <?php endif; ?>

  <?php if(isset($_GET['imported'])): ?>
    <div class="alert alert-success">📥 Berhasil import <?= $_GET['imported'] ?> member!</div>
  <?php endif; ?>

  <div class="mb-3 d-flex gap-2 flex-wrap">
    <a href="tambah_member.php" class="btn btn-primary"><i class="bi bi-plus-circle"></i> Tambah Member</a>
    <a href="template_member.csv" class="btn btn-outline-secondary"><i class="bi bi-download"></i> Template CSV</a>
    <form action="import_member.php" method="post" enctype="multipart/form-data" class="d-flex gap-2">
      <input type="file" name="file" required class="form-control form-control-sm">
      <button type="submit" class="btn btn-success"><i class="bi bi-upload"></i> Import CSV</button>
    </form>
  </div>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table table-hover mb-0">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Member ID</th>
            <th>Nama</th>
            <th>Kelas/Jurusan</th>
            <th>Aksi</th>
          </tr>
        </thead>
        <tbody>
        <?php if(empty($members)): ?>
          <tr><td colspan="5" class="text-center">Tidak ada data</td></tr>
        <?php else: ?>
          <?php foreach($members as $i => $m): ?>
          <tr>
            <td><?= $offset + $i + 1 ?></td>
            <td><?= htmlspecialchars($m['member_id']) ?></td>
            <td><?= htmlspecialchars($m['nama']) ?></td>
            <td><?= htmlspecialchars($m['kelas_jurusan']) ?></td>
            <td>
              <a href="edit_member.php?id=<?= $m['id'] ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil"></i></a>
              <a href="hapus_member.php?id=<?= $m['id'] ?>" onclick="return confirm('Yakin hapus?')" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></a>
            </td>
          </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Pagination -->
  <?php
// ... (bagian PHP sebelumnya tetap sama)

// Pagination range
$showPages = 5; // jumlah halaman yang ditampilkan di sekitar halaman aktif
$startPage = max(1, $page - floor($showPages / 2));
$endPage   = min($totalPages, $startPage + $showPages - 1);

// koreksi agar jumlah tetap $showPages
if ($endPage - $startPage + 1 < $showPages) {
    $startPage = max(1, $endPage - $showPages + 1);
}
?>
<!-- Pagination -->
<nav class="mt-3">
  <ul class="pagination justify-content-center">
    <?php if ($page > 1): ?>
      <li class="page-item"><a class="page-link" href="?page=<?= $page-1 ?>&search=<?= urlencode($search) ?>">« Prev</a></li>
    <?php endif; ?>

    <?php if ($startPage > 1): ?>
      <li class="page-item"><a class="page-link" href="?page=1&search=<?= urlencode($search) ?>">1</a></li>
      <?php if ($startPage > 2): ?>
        <li class="page-item disabled"><span class="page-link">...</span></li>
      <?php endif; ?>
    <?php endif; ?>

    <?php for($p = $startPage; $p <= $endPage; $p++): ?>
      <li class="page-item <?= $p==$page ? 'active' : '' ?>">
        <a class="page-link" href="?page=<?= $p ?>&search=<?= urlencode($search) ?>"><?= $p ?></a>
      </li>
    <?php endfor; ?>

    <?php if ($endPage < $totalPages): ?>
      <?php if ($endPage < $totalPages - 1): ?>
        <li class="page-item disabled"><span class="page-link">...</span></li>
      <?php endif; ?>
      <li class="page-item"><a class="page-link" href="?page=<?= $totalPages ?>&search=<?= urlencode($search) ?>"><?= $totalPages ?></a></li>
    <?php endif; ?>

    <?php if ($page < $totalPages): ?>
      <li class="page-item"><a class="page-link" href="?page=<?= $page+1 ?>&search=<?= urlencode($search) ?>">Next »</a></li>
    <?php endif; ?>
  </ul>
</nav>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
