<?php
session_start();
if (!isset($_SESSION['login'])) { header("Location: login.php"); exit; }
require 'koneksi.php';

$members = $koneksi->query("SELECT * FROM tb_member ORDER BY member_id ASC");
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title>Kelola Member</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
<?php include 'navbar.php'; ?>

<div class="container py-4">
  <h4><i class="bi bi-people-fill"></i> Data Member</h4>
  <a href="tambah_member.php" class="btn btn-primary mb-3"><i class="bi bi-person-plus"></i> Tambah Member</a>

  <div class="table-responsive">
    <table class="table table-bordered table-hover">
      <thead class="table-light">
        <tr>
          <th>ID</th>
          <th>Nama</th>
          <th>Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php while($m = $members->fetch_assoc()): ?>
        <tr>
          <td><?= htmlspecialchars($m['member_id']) ?></td>
          <td><?= htmlspecialchars($m['nama']) ?></td>
          <td>
            <a href="edit_member.php?id=<?= $m['member_id'] ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil"></i></a>
            <a href="hapus_member.php?id=<?= $m['member_id'] ?>" onclick="return confirm('Hapus data?')" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></a>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
