<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}
require 'koneksi.php';

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $member_id = trim($_POST['member_id']);
    $nama = trim($_POST['nama']);
    $kelas_jurusan = trim($_POST['kelas_jurusan']);

    // cek apakah member_id sudah ada
    $cek = $conn->prepare("SELECT id FROM tb_member WHERE member_id=?");
    $cek->bind_param("s", $member_id);
    $cek->execute();
    $cek->store_result();

    if ($cek->num_rows > 0) {
        $error = "Member ID sudah terdaftar!";
    } else {
        $stmt = $conn->prepare("INSERT INTO tb_member (member_id, nama, kelas_jurusan) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $member_id, $nama, $kelas_jurusan);
        $stmt->execute();
        header("Location: member.php?msg=added");
        exit;
    }
    $cek->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Tambah Member</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
  <h4>Tambah Member</h4>
  <?php if($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
  <?php endif; ?>
  <form method="post">
    <div class="mb-3">
      <label class="form-label">Member ID</label>
      <input type="text" name="member_id" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Nama</label>
      <input type="text" name="nama" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Kelas/Jurusan</label>
      <input type="text" name="kelas_jurusan" class="form-control" required>
    </div>
    <button class="btn btn-primary">Simpan</button>
    <a href="member.php" class="btn btn-secondary">Kembali</a>
  </form>
</div>
</body>
</html>
